<?php defined('EMLOG_ROOT') or die('本页面禁止直接访问!');
/*
Plugin Name: 彩虹聚合登录
Version: 1.1
Plugin URL: https://www.clogin.cc/
Description: 通过彩虹聚合登录实现QQ和微信登录
Author: 彩虹
*/

const CLOGIN_ROOT = EMLOG_ROOT . '/content/plugins/Clogin';
const CLOGIN_URL = BLOG_URL . 'content/plugins/Clogin';

function Clogin_menu() {
    echo '<a class="collapse-item" id="Clogin" href="plugin.php?plugin=Clogin">QQ/微信登录</a>';
}

addAction('adm_menu_ext', 'Clogin_menu');

function Clogin_logining() {
    if (ISLOGIN) {
        header('location:/admin/index.php');
    } else {
        header('location:/?plugin=Clogin');
    }
}

function Clogin_qq_login() {
    $plugin_storage = Storage::getInstance('Clogin');
    $qq_login_enabled = $plugin_storage->getValue('qq_login_enabled', '1');
    $wechat_login_enabled = $plugin_storage->getValue('wechat_login_enabled', '0');
    
    if ($qq_login_enabled == '0' && $wechat_login_enabled == '0') {
        return;
    }
    ?>
    <div class="text-center">
        <?php if ($qq_login_enabled == '1'): ?>
            <a href="<?= CLOGIN_URL; ?>/Clogin_ajax.php?a=qq_login" class="ajax_qq_login am-icon-qq" title="QQ登录"></a>
        <?php endif; ?>
        <?php if ($wechat_login_enabled == '1'): ?>
            <a href="<?= CLOGIN_URL; ?>/Clogin_ajax.php?a=wechat_login" class="ajax_wechat_login am-icon-wechat" title="微信登录"></a>
        <?php endif; ?>
    </div>
    <style>
        .am-icon-qq, .am-icon-wechat {
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
            display: inline-block;
            width: 30px;
            height: 30px;
            font-size: 18px;
            line-height: 30px;
            border-radius: 50%;
            color: #fff;
            text-align: center;
            background-size: cover;
            margin-top: 12px;
            margin-right: 8px;
        }
        .am-icon-qq {
            background-color: #26CEFE;
            background: url('<?= CLOGIN_URL; ?>/images/qq_login.png');
            background-size: cover;
        }
        .am-icon-wechat {
            background-color: #07C160;
            background: url('<?= CLOGIN_URL; ?>/images/wechat_login.png');
            background-size: cover;
        }
    </style>
    <?
}

function Clogin_qq_bind() {
    $plugin_storage = Storage::getInstance('Clogin');
    $qq_login_enabled = $plugin_storage->getValue('qq_login_enabled', '1');
    $wechat_login_enabled = $plugin_storage->getValue('wechat_login_enabled', '0');
    
    if ($qq_login_enabled == '0' && $wechat_login_enabled == '0') {
        return;
    }
    ?>
    <hr>
    <h4 class="mt-4 mb-3" id="social_connect">绑定社交账号</h4>
    <div>
        <?php
        $DB = Database::getInstance();
        $row = $DB->once_fetch_array("SELECT * FROM `" . DB_PREFIX . "user` WHERE `uid` =  '" . UID . "' ");
        $qq_login_openid = isset($row['qq_login_openid']) ? $row['qq_login_openid'] : '';
        $wechat_login_openid = isset($row['wechat_login_openid']) ? $row['wechat_login_openid'] : '';
        
        if ($qq_login_enabled == '1'):
        ?>
        <div class="mb-3">
            <strong>QQ绑定：</strong>
            <?php if (empty($qq_login_openid)) : ?>
                <a id="qq_login" class="am-icon-qq" href="#social_connect"></a>
                <a id="qq_login_unbind" class="text-danger" href="#social_connect" style="display: none">解除QQ绑定</a>
            <?php else: ?>
                已绑定(<?=substr($qq_login_openid, 0, 10)?>...)<br/>
                <a id="qq_login" class="am-icon-qq" href="#social_connect" style="display: none"></a>
                <a id="qq_login_unbind" class="text-danger" href="#social_connect" onclick="return confirm('确定解除QQ绑定？解除后将无法使用QQ一键登录到本站')">解除QQ绑定</a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
        <?php if ($wechat_login_enabled == '1'):
        ?>
        <div class="mb-3">
            <strong>微信绑定：</strong>
            <?php if (empty($wechat_login_openid)) : ?>
                <a id="wechat_login" class="am-icon-wechat" href="#social_connect"></a>
                <a id="wechat_login_unbind" class="text-danger" href="#social_connect" style="display: none">解除微信绑定</a>
            <?php else: ?>
                已绑定(<?=substr($wechat_login_openid, 0, 10)?>...)<br/>
                <a id="wechat_login" class="am-icon-wechat" href="#social_connect" style="display: none"></a>
                <a id="wechat_login_unbind" class="text-danger" href="#social_connect" onclick="return confirm('确定解除微信绑定？解除后将无法使用微信一键登录到本站')">解除微信绑定</a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
    <style>
        .am-icon-qq, .am-icon-wechat {
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
            display: inline-block;
            width: 30px;
            height: 30px;
            font-size: 18px;
            line-height: 30px;
            border-radius: 50%;
            color: #fff;
            text-align: center;
            background-size: cover;
        }
        .am-icon-qq {
            background-color: #26CEFE;
            background: url('<?= CLOGIN_URL; ?>/images/qq_login.png');
            background-size: cover;
        }
        .am-icon-wechat {
            background-color: #07C160;
            background: url('<?= CLOGIN_URL; ?>/images/wechat_login.png');
            background-size: cover;
        }
    </style>
    <script>
        function bangdingok(type) {
            if (type === 'qq') {
                document.getElementById('qq_login').style.display = 'block';
                document.getElementById('qq_login_unbind').style.display = 'none';
            } else if (type === 'wechat') {
                document.getElementById('wechat_login').style.display = 'block';
                document.getElementById('wechat_login_unbind').style.display = 'none';
            }
        }

        function handleQQLoginClick() {
            window.open("<?php echo CLOGIN_URL; ?>/Clogin_ajax.php?a=qq_bind", "qq_bangding", "top=200,left=200,height=600, width=800, toolbar=no, menubar=no, scrollbars=no, resizable=no, location=no, status=no");
        }

        function handleWechatLoginClick() {
            window.open("<?php echo CLOGIN_URL; ?>/Clogin_ajax.php?a=wechat_bind", "wechat_bangding", "top=200,left=200,height=600, width=800, toolbar=no, menubar=no, scrollbars=no, resizable=no, location=no, status=no");
        }

        function handleQQLoginJiebangClick() {
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '<?php echo CLOGIN_URL; ?>/Clogin_ajax.php?a=qq_unbind');
            xhr.setRequestHeader('Content-Type', 'application/json');
            xhr.onload = function () {
                if (xhr.status === 200) {
                    var data = JSON.parse(xhr.responseText);
                    if (data.code === '200') {
                        bangdingok('qq');
                    }
                }
            };
            xhr.send(JSON.stringify({}));
        }

        function handleWechatLoginJiebangClick() {
            var xhr = new XMLHttpRequest();
            xhr.open('POST', '<?php echo CLOGIN_URL; ?>/Clogin_ajax.php?a=wechat_unbind');
            xhr.setRequestHeader('Content-Type', 'application/json');
            xhr.onload = function () {
                if (xhr.status === 200) {
                    var data = JSON.parse(xhr.responseText);
                    if (data.code === '200') {
                        bangdingok('wechat');
                    }
                }
            };
            xhr.send(JSON.stringify({}));
        }

        document.addEventListener('DOMContentLoaded', function () {
            <?php if ($qq_login_enabled == '1'): ?>
            if (document.getElementById('qq_login')) {
                document.getElementById('qq_login').addEventListener('click', handleQQLoginClick);
            }
            if (document.getElementById('qq_login_unbind')) {
                document.getElementById('qq_login_unbind').addEventListener('click', handleQQLoginJiebangClick);
            }
            <?php endif; ?>
            
            <?php if ($wechat_login_enabled == '1'): ?>
            if (document.getElementById('wechat_login')) {
                document.getElementById('wechat_login').addEventListener('click', handleWechatLoginClick);
            }
            if (document.getElementById('wechat_login_unbind')) {
                document.getElementById('wechat_login_unbind').addEventListener('click', handleWechatLoginJiebangClick);
            }
            <?php endif; ?>
        });
    </script>
    <?php
}

addAction('login_ext', 'Clogin_qq_login');
addAction('blogger_ext', 'Clogin_qq_bind');