<?php
/**
 * ajax登录验证模块
 */
session_start();
require_once('../../../init.php');

//载入配置
$plugin_storage = Storage::getInstance('Clogin');
$OAuthConfig['apiurl'] = $plugin_storage->getValue('oauth_apiurl');
$OAuthConfig['appid'] = $plugin_storage->getValue('oauth_appid');
$OAuthConfig['appkey'] = $plugin_storage->getValue('oauth_appkey');
$qq_login_enabled = $plugin_storage->getValue('qq_login_enabled', '1');
$wechat_login_enabled = $plugin_storage->getValue('wechat_login_enabled', '0');

$a = Input::getStrVar('a');

// QQ登录
if ($a == 'qq_login') {
    if ($qq_login_enabled != '1') {
        emMsg('QQ登录功能未开启');
    }
    $OAuthConfig['callback'] = CLOGIN_URL . "/Clogin_ajax.php?a=callback_login&type=qq";
    require_once("class/Oauth.class.php");
    $oauth = new Oauth($OAuthConfig);
    $result = $oauth->login('qq');
    if(isset($result['code']) && $result['code']==0){
        header('Location: '.$result['url']);
    }elseif(isset($arr['code'])){
        emMsg('登录接口返回：'.$arr['msg']);
    }else{
        emMsg('获取登录地址失败');
    }
}

// 微信登录
if ($a == 'wechat_login') {
    if ($wechat_login_enabled != '1') {
        emMsg('微信登录功能未开启');
    }
    $OAuthConfig['callback'] = CLOGIN_URL . "/Clogin_ajax.php?a=callback_login&type=wechat";
    require_once("class/Oauth.class.php");
    $oauth = new Oauth($OAuthConfig);
    $result = $oauth->login('wechat');
    if(isset($result['code']) && $result['code']==0){
        header('Location: '.$result['url']);
    }elseif(isset($arr['code'])){
        emMsg('登录接口返回：'.$arr['msg']);
    }else{
        emMsg('获取登录地址失败');
    }
}

// QQ绑定
if ($a == 'qq_bind') {
    if ($qq_login_enabled != '1') {
        emMsg('QQ绑定功能未开启');
    }
    $OAuthConfig['callback'] = CLOGIN_URL . "/Clogin_ajax.php?a=callback_bind&type=qq";
    if (ISLOGIN) {
        require_once("class/Oauth.class.php");
        $oauth = new Oauth($OAuthConfig);
        $result = $oauth->login('qq');
        if(isset($result['code']) && $result['code']==0){
            header('Location: '.$result['url']);
        }elseif(isset($arr['code'])){
            emMsg('登录接口返回：'.$arr['msg']);
        }else{
            emMsg('获取登录地址失败');
        }
    } else {
        emMsg('请先登录再绑定QQ');
    }
}

// 微信绑定
if ($a == 'wechat_bind') {
    if ($wechat_login_enabled != '1') {
        emMsg('微信绑定功能未开启');
    }
    $OAuthConfig['callback'] = CLOGIN_URL . "/Clogin_ajax.php?a=callback_bind&type=wechat";
    if (ISLOGIN) {
        require_once("class/Oauth.class.php");
        $oauth = new Oauth($OAuthConfig);
        $result = $oauth->login('wechat');
        if(isset($result['code']) && $result['code']==0){
            header('Location: '.$result['url']);
        }elseif(isset($arr['code'])){
            emMsg('登录接口返回：'.$arr['msg']);
        }else{
            emMsg('获取登录地址失败');
        }
    } else {
        emMsg('请先登录再绑定微信');
    }
}

// QQ解绑
if ($a == 'qq_unbind') {
    $DB = Database::getInstance();
    $sql = 'UPDATE `' . DB_PREFIX . 'user` SET `qq_login_openid`="" WHERE  `uid`=' . UID . ';';
    $r = $DB->query($sql);
    if ($r) {
        echo json_encode(array(
            'code' => '200',
            'data' => '解绑成功'
        ));
    } else {
        echo json_encode(array(
            'code' => '206',
            'data' => '解绑失败'
        ));
    }
    die;
}

// 微信解绑
if ($a == 'wechat_unbind') {
    $DB = Database::getInstance();
    $sql = 'UPDATE `' . DB_PREFIX . 'user` SET `wechat_login_openid`="" WHERE  `uid`=' . UID . ';';
    $r = $DB->query($sql);
    if ($r) {
        echo json_encode(array(
            'code' => '200',
            'data' => '解绑成功'
        ));
    } else {
        echo json_encode(array(
            'code' => '206',
            'data' => '解绑失败'
        ));
    }
    die;
}

// 绑定回调 - 修复版（支持新版聚合登录）
if ($a == 'callback_bind') {
    $type = Input::getStrVar('type', 'qq');
    
    if (ISLOGIN) {
        // 新版聚合登录直接传递用户信息，不需要state验证
        $social_uid = Input::getStrVar('social_uid');
        $nickname = Input::getStrVar('nickname');
        $faceimg = Input::getStrVar('faceimg');
        
        if (!empty($social_uid)) {
            // 新版聚合登录回调处理
            $openid = $social_uid;
            
            $DB = Database::getInstance();
            
            if ($type == 'qq') {
                $field = 'qq_login_openid';
                $login_type = 'QQ';
            } else {
                $field = 'wechat_login_openid';
                $login_type = '微信';
            }
            
            // 检查该openid是否已被其他账号绑定
            $check_data = $DB->once_fetch_array("SELECT * FROM " . DB_PREFIX . "user WHERE $field = '" . $openid . "'");
            if (!empty($check_data[$field]) && $check_data['uid'] != UID) {
                echo '<script>alert("该'.$login_type.'已绑定其他账号");window.close();</script>';
                exit;
            }
            
            // 更新当前用户的绑定信息
            $User_Model = new User_Model();
            $User_Model->updateUser(array($field => $openid), UID);
            echo '<script>alert("绑定成功");window.close();window.opener.location.reload();</script>';
            exit;
        }
        
        // 旧版回调处理（保留兼容性）
        if($_GET['state'] != $_SESSION['Oauth_state']){
            echo '<script>alert("state参数校验失败");window.close();</script>';exit;
        }
        
        require_once("class/Oauth.class.php");
        global $user_cache;
        global $CACHE;
        $oauth = new Oauth($OAuthConfig);
        $result = $oauth->callback();
        
        if(isset($result['code']) && $result['code']==0){
            $openid = $result['social_uid'];
            
            if ($type == 'qq') {
                $field = 'qq_login_openid';
                $login_type = 'QQ';
            } else {
                $field = 'wechat_login_openid';
                $login_type = '微信';
            }

            $DB = Database::getInstance();
            // 检查该openid是否已被其他账号绑定
            $check_data = $DB->once_fetch_array("SELECT * FROM " . DB_PREFIX . "user WHERE $field = '" . $openid . "'");
            if (!empty($check_data[$field]) && $check_data['uid'] != UID) {
                echo '<script>alert("该'.$login_type.'已绑定其他账号");window.close();</script>';
                exit;
            }
            
            // 更新当前用户的绑定信息
            $User_Model = new User_Model();
            $User_Model->updateUser(array($field => $openid), UID);
            echo '<script>alert("绑定成功");window.close();window.opener.location.reload();</script>';
        }elseif(isset($result['code'])){
            echo '<script>alert("'.$result['msg'].'");window.close();</script>';
        }else{
            echo '<script>alert("获取登录数据失败");window.close();</script>';
        }
    }
}

// 登录回调 - 修复版（支持新版聚合登录）
if ($a == 'callback_login') {
    $type = Input::getStrVar('type', 'qq');
    
    // 新版聚合登录直接传递用户信息，不需要state验证
    $social_uid = Input::getStrVar('social_uid');
    $nickname = Input::getStrVar('nickname');
    $faceimg = Input::getStrVar('faceimg');
    
    if (!empty($social_uid)) {
        // 新版聚合登录回调处理
        require_once("class/Oauth.class.php");
        global $user_cache;
        global $CACHE;
        
        $openid = $social_uid;
        
        if ($type == 'qq') {
            $field = 'qq_login_openid';
        } else {
            $field = 'wechat_login_openid';
        }
        
        $DB = Database::getInstance();
        $data = $DB->once_fetch_array("SELECT * FROM " . DB_PREFIX . "user WHERE $field='$openid'");
        if ($data) {
            LoginAuth::setAuthCookie($data['username']);
            header('Location:' . BLOG_URL);
        } else {
            // 检查是否开启用户注册
            if (Option::get("is_signup") !== 'y') {
                $login_type = $type == 'qq' ? 'QQ' : '微信';
                emMsg('该'.$login_type.'未绑定本站用户，请先到用户中心绑定', '/');
                exit;
            }

            $PHPASS = new PasswordHash(8, true);
            $password = $PHPASS->HashPassword(getRandStr(16));
            $username = getRandStr(8, false);
            $uid = Clogin_addUser($username, '', $password, 'writer', $openid, $type);
            if (!$uid) {
                emMsg('用户注册失败', '/');
            }

            $CACHE = Cache::getInstance();
            $CACHE->updateCache(['sta', 'user']);

            LoginAuth::setAuthCookie($username, 1);
            header('Location:' . BLOG_URL);
        }
        exit;
    }
    
    // 旧版回调处理（保留兼容性）
    require_once("class/Oauth.class.php");
    global $user_cache;
    global $CACHE;
    
    if($_GET['state'] != $_SESSION['Oauth_state']){
        emMsg('state参数校验失败', '/');
    }
    
    $oauth = new Oauth($OAuthConfig);
    $result = $oauth->callback();
    
    if(isset($result['code']) && $result['code']==0){
        $openid = $result['social_uid'];
        
        if ($type == 'qq') {
            $field = 'qq_login_openid';
        } else {
            $field = 'wechat_login_openid';
        }

        $DB = Database::getInstance();
        $data = $DB->once_fetch_array("SELECT * FROM " . DB_PREFIX . "user WHERE $field='$openid'");
        if ($data) {
            LoginAuth::setAuthCookie($data['username']);
            header('Location:' . BLOG_URL);
        } else {
            // 检查是否开启用户注册
            if (Option::get("is_signup") !== 'y') {
                $login_type = $type == 'qq' ? 'QQ' : '微信';
                emMsg('该'.$login_type.'未绑定本站用户，请先到用户中心绑定', '/');
                exit;
            }

            $PHPASS = new PasswordHash(8, true);
            $password = $PHPASS->HashPassword(getRandStr(16));
            $username = getRandStr(8, false);
            $uid = Clogin_addUser($username, '', $password, 'writer', $openid, $type);
            if (!$uid) {
                emMsg('用户注册失败', '/');
            }

            $CACHE = Cache::getInstance();
            $CACHE->updateCache(['sta', 'user']);

            LoginAuth::setAuthCookie($username, 1);
            header('Location:' . BLOG_URL);
        }
    }elseif(isset($result['code'])){
        emMsg('登录失败：'.$result['msg'], '/');
    }else{
        emMsg('登录失败：获取登录数据失败', '/');
    }
}

function Clogin_addUser($username, $mail, $password, $role, $openid, $type = 'qq') {
    $DB = Database::getInstance();
    $timestamp = time();
    $nickname = 'user-' . getRandStr(8, false);
    
    if ($type == 'qq') {
        $sql = "insert into " . DB_PREFIX . "user (username,email,password,nickname,role,qq_login_openid,create_time,update_time) values('$username','$mail','$password','$nickname','$role','$openid',$timestamp,$timestamp)";
    } else {
        $sql = "insert into " . DB_PREFIX . "user (username,email,password,nickname,role,wechat_login_openid,create_time,update_time) values('$username','$mail','$password','$nickname','$role','$openid',$timestamp,$timestamp)";
    }
    
    $DB->query($sql);
    return $DB->insert_id();
}