<?php
class Clogin_Widget extends Widget_Abstract_Users
{
    private $referer = ''; // 来源页面

    public function __construct($request, $response, $params = null)
    {
        parent::__construct($request, $response, $params);
    }
    
    /**
     * 获取用户绑定信息
     *
     * @access public
     */
    public function userinfo(){
        $data = ['code'=>0];
        if ($this->user->hasLogin()) {
            $types = Clogin_Plugin::LOGIN_TYPE;
            $opentype = Clogin_Plugin::getoptions()->opentype;
            $list = [];
            foreach ($opentype as $type) {
                $user = $this->db->fetchRow($this->db->select()->from('table.connect_user')->where('uid = ?', $this->user->uid)->where('type = ?', $type)->limit(1));
                $url = Typecho_Common::url('/connect?type='.$type, Typecho_Widget::Widget('Widget_Options')->index);
                $list[] = ['type'=>$type, 'name'=>$types[$type], 'isbind'=>$user?true:false, 'url'=>$url, 'openid'=>$user['openid']];
            }
            $data['data'] = $list;
        }else{
            $data = ['code'=>-1,'msg'=>'no login'];
        }
        $this->response->throwJson($data);
    }
    
    /**
     * 获取Oauth登录地址，重定向
     *
     * @access public
     * @param string $type 第三方登录类型
     */
    public function connect()
    {
        $type = $this->request->get('type');
        if (is_null($type)) throw new Typecho_Widget_Exception("请选择登录方式!");

        $type = strtolower($type);
        $options = Clogin_Plugin::getoptions();

        // 映射类型名称：wx -> wechat
        $api_type = ($type == 'wx') ? 'wechat' : $type;
        
        if (!in_array($type, $options->opentype)) {
            throw new Typecho_Widget_Exception("不支持该登录方式!");
        }

        // 保存来源页面到session
        if (session_status() != PHP_SESSION_ACTIVE) {
            session_start();
        }
        $_SESSION['Clogin_Referer'] = $this->request->getReferer();

        // 构建回调地址
        $callback = Typecho_Common::url('/connect_callback?type='.$api_type, Typecho_Widget::Widget('Widget_Options')->index);
        
        // 调用你的OAuth系统
        $api_url = rtrim($options->apiurl, '/') . '/connect.php';
        $params = [
            'act' => 'login',
            'appid' => $options->appid,
            'appkey' => $options->appkey,
            'type' => $api_type,
            'redirect_uri' => $callback
        ];
        
        $request_url = $api_url . '?' . http_build_query($params);
        
        error_log("Clogin请求URL: " . $request_url);
        
        // 发送请求获取JSON响应
        $context = stream_context_create([
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
            ],
            'http' => [
                'timeout' => 10,
                'ignore_errors' => true
            ]
        ]);
        
        $response = @file_get_contents($request_url, false, $context);
        
        if ($response === false) {
            throw new Typecho_Widget_Exception("获取登录地址失败：网络请求错误");
        }
        
        $result = json_decode($response, true);
        
        if (!$result || !isset($result['code']) || $result['code'] != 0) {
            $error_msg = isset($result['msg']) ? $result['msg'] : '未知错误';
            throw new Typecho_Widget_Exception("获取登录地址失败：" . $error_msg);
        }
        
        if (empty($result['url'])) {
            throw new Typecho_Widget_Exception("登录地址为空");
        }
        
        $login_url = $result['url'];
        error_log("Clogin跳转到: " . $login_url);
        
        // 跳转到真正的登录页面
        $this->response->redirect($login_url);
    }
    
    /**
     * 第三方登录回调
     *
     * @access public
     */
    public function callback()
    {
        //开户session
        if (session_status() != PHP_SESSION_ACTIVE) {
            session_start();
        }
        
        // session内取出来源页
        $this->referer = isset($_SESSION['Clogin_Referer']) ? $_SESSION['Clogin_Referer'] : '';
        unset($_SESSION['Clogin_Referer']);
        
        $types = Clogin_Plugin::LOGIN_TYPE;
        $options = Clogin_Plugin::getoptions();

        // 从GET参数获取用户信息
        $raw_type = $this->request->get('type', 'qq');
        $social_uid = $this->request->get('social_uid', '');
        $nickname = $this->request->get('nickname', '');
        $faceimg = $this->request->get('faceimg', '');
        $gender = $this->request->get('gender', 0);
        $location = $this->request->get('location', '');
        $access_token = $this->request->get('access_token', '');

        // 根据原始type参数判断类型
        if (strpos($raw_type, 'wechat') !== false) {
            $api_type = 'wechat';
            $local_type = 'wx';
            $typename = '微信';
        } elseif (strpos($raw_type, 'qq') !== false) {
            $api_type = 'qq';
            $local_type = 'qq';
            $typename = 'QQ';
        } else {
            // 默认处理
            $api_type = $raw_type;
            $local_type = $raw_type;
            $typename = isset($types[$local_type]) ? $types[$local_type] : $local_type;
        }

        // 调试信息
        error_log("回调参数 - raw_type: $raw_type, api_type: $api_type, local_type: $local_type, typename: $typename");

        if (empty($social_uid)) {
            $this->widget('Widget_Notice')->set(array('登录失败：未获取到用户信息'), 'error');
            $this->response->redirect(empty($this->referer) ? $this->options->index : $this->referer);
        }

        if ($this->user->hasLogin()) {
            // 已登录用户进行绑定
            $user = $this->findUser($social_uid, $local_type);
            if($user && $user['uid']!=$this->user->uid){
                $this->widget('Widget_Notice')->set(array('该'.$typename.'账号已被本站其他用户绑定，请更换'.$typename.'账号重试'));
                $this->response->redirect(empty($this->referer) ? $this->options->index : $this->referer);
            }elseif(!$user){
                $this->bindUser($this->user->uid, $local_type, $social_uid);
            }
            $this->widget('Widget_Notice')->set(array('绑定'.$typename.'账号成功'));
            $this->response->redirect(empty($this->referer) ? $this->options->index : $this->referer);
        }else{
            // 未登录用户进行登录
            $user = $this->findUser($social_uid, $local_type);
            if($user){
                //已经绑定，直接登录
                $this->useUidLogin($user['uid']);
                $this->widget('Widget_Notice')->set(array('登录成功'));
                $this->response->redirect(empty($this->referer) ? $this->options->index : $this->referer);
            }else{
                if($options->autoreg == 1){
                    //新注册账号
                    $uid = $this->regUser($local_type, $social_uid, $nickname);
                    if ($uid) {
                        $this->widget('Widget_Notice')->set(array('已成功注册并登陆'));
                    } else {
                        $this->widget('Widget_Notice')->set(array('注册用户失败'), 'error');
                    }
                    $this->response->redirect(empty($this->referer) ? $this->options->index : $this->referer);
                }else{
                    $this->widget('Widget_Notice')->set(array('该'.$typename.'账号未绑定本站用户，请使用用户名登录后绑定'));
                    $this->response->redirect(empty($this->referer) ? $this->options->index : $this->referer);
                }
            }
        }
    }

    //注册用户
    private function regUser($type, $openid, $nickname)
    {
        $data = array(
            'name' => 'o'.Typecho_Common::randString(9),
            'screenName'=>  $nickname,
            'created'   =>  $this->options->gmtTime,
            'group'     =>  'subscriber'
        );
        $insertId = $this->insert($data);
        if ($insertId) {
            $this->bindUser($insertId, $type, $openid);
            $this->useUidLogin($insertId);
            return $insertId;
        } else {
            return false;
        }
    }

    //绑定用户
    private function bindUser($uid, $type, $openid)
    {
        $oauth_user = ['uid'=>$uid, 'type'=>$type, 'openid'=>$openid, 'addtime'=>date("Y-m-d H:i:s")];
        $this->db->query($this->db->insert('table.connect_user')->rows($oauth_user));
    }

    //查找第三方账号
    private function findUser($openid, $type)
    {
        return $this->db->fetchRow($this->db->select()
            ->from('table.connect_user')
            ->where('openid = ?', $openid)
            ->where('type = ?', $type)
            ->limit(1));
    }

    //使用用户uid登录
    private function useUidLogin($uid, $expire = 0)
    {
        $authCode = function_exists('openssl_random_pseudo_bytes') ?
        bin2hex(openssl_random_pseudo_bytes(16)) : sha1(Typecho_Common::randString(20));
        $user = array('uid'=>$uid,'authCode'=>$authCode);

        Typecho_Cookie::set('__typecho_uid', $uid, $expire);
        Typecho_Cookie::set('__typecho_authCode', Typecho_Common::hash($authCode), $expire);

        //更新最后登录时间以及验证码
        $this->db->query($this->db
            ->update('table.users')
            ->expression('logged', 'activated')
            ->rows(array('authCode' => $authCode))
            ->where('uid = ?', $uid));
    }

}